import UIKit
extension ViewController
{
    func scaleAction(inpTouchOne: UITouch,
                     inpTouchTwo: UITouch,
                     inpView: UIView) -> CGFloat
    {
        let curLoc_t1 = inpTouchOne.location(in: inpView)
        let curLoc_t2 = inpTouchTwo.location(in: inpView)
        
        let preLoc_t1 = inpTouchOne.previousLocation(in: inpView)
        let preLoc_t2 = inpTouchTwo.previousLocation(in: inpView)
        
        let curDist = distAction(inpPointOne: curLoc_t1, inpPointTwo: curLoc_t2)
        let preDist = distAction(inpPointOne: preLoc_t1, inpPointTwo: preLoc_t2)
        
        let scaleRatio = curDist / preDist
        return scaleRatio
    }
}
